/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: CommandPackage.cpp                                                 *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              04/05/2007       1.1                              *
*******************************************************************************/

#include "CommandPackage.h"

commandPackage::commandPackage () { }

commandPackage::~commandPackage () { }

char * commandPackage::buildPackage(commPackage *cpack, int& nlen) {

    int i;
    char *msg;

    switch(cpack->tc) {
        case OPEN:
            nlen = 3+strlen(cpack->disp)+1;
            msg = new char[nlen];
            msg[0] = (char) OPEN;
            msg[1] = (char) cpack->usbin;
            msg[2] = (char) cpack->usbout;
            for (i=0; i< nlen-3; i++) {
                msg[i+3] = cpack->disp[i];
            };
            msg[nlen] = (char)('\0');
            break;
        case CLOSE:
            nlen = 2;
            msg = new char[2];
            msg[0] = (char) CLOSE;
            msg[1] = (char) cpack->hnd;
            break;
        case MESSAGE:
            break;
        case LOAD:
            break;
        case UNLOAD:
            break;
        case GETMAP:
            break;
        case NOTHING:
            break;
    };
    return msg;
}

commPackage* commandPackage::unbuildPackage(char *msg, int len) {

    commPackageResponse *cpackres;
    cpackres = (commPackageResponse *) msg;
    commPackage *cpack = new commPackage();
    cpack->tc = (command) cpackres->tc;
    switch (cpack->tc) {
        case OPEN:
            cpack->h = (handler) cpackres->h;
            break;
        case CLOSE:
            cpack->res = cpackres->res;
            break;
        case MESSAGE:
            cpack->usbin = (int) cpackres->h;
            break;
        case LOAD:
            break;
        case UNLOAD:
            break;
        case GETMAP:
            break;
        case NOTHING:
            break;
    };
    return cpack;
}
